
# AR Maintenance & Inspection Assistant – Data Storage

This project stores IoT sensor data received via MQTT in a PostgreSQL database enhanced with **TimescaleDB** for efficient time-series data management.

---

## ✨ Features

- Real-time ingestion of sensor data via MQTT
- Efficient time-series storage using TimescaleDB
- Direct SQL access via the `pg` client
- Type-safe backend powered by **TypeScript**
- Dockerized setup for consistent development environments
- SQL-based schema initialization

---

## 🧰 Tech Stack

- **TypeScript**
- **Node.js**
- **MQTT**
- **PostgreSQL + TimescaleDB**
- **pg** (`node-postgres`)
- **Docker Compose**

---

## 🚀 Getting Started

### 1. Clone the Repository

```bash
git clone <repo-url>
cd <repo-folder>
```

### 2. Install Dependencies

```bash
npm install
```

### 3. Start Docker Services

This project uses Docker to run TimescaleDB:

```bash
docker-compose up -d
```

> This also initializes the database schema using a mounted `init.sql`.

### 4. Run the Application

```bash
npm run start
```

---

## 🧱 Database Schema

- Sensor data is written into a **hypertable** (TimescaleDB feature).
- Schema is initialized via `init.sql`.
- The application uses a custom `Database` class (singleton) with the `pg` client for raw SQL queries.

---

## 🐳 Docker Setup

Add this to your `docker-compose.yml`:

```yaml
timeseries-db:
  image: timescale/timescaledb:latest-pg17
  container_name: AR_Assistent_TimeseriesDB
  ports:
    - "5434:5432"
  volumes:
    - AR_Assistent_TimeseriesDB:/var/lib/postgresql/data
  environment:
    POSTGRES_USER: testing
    POSTGRES_PASSWORD: password
    POSTGRES_DB: AR_Assistent_TimeseriesDB
  volumes:
    - ./init.sql:/docker-entrypoint-initdb.d/init.sql
```

> Adjust ports or credentials if needed.

### Access the Database (optional)

```bash
docker exec -it AR_Assistent_TimeseriesDB psql -U testing -d AR_Assistent_TimeseriesDB
```

---

## 📡 MQTT Client

The app listens for incoming MQTT messages and stores them in the database.

### Sample Payload

```json
{
  "machineId": "1",
  "sensorType": "temperature",
  "value": 23.4,
  "unit": "°C",
  "timestamp": "2025-05-21T14:25:18.307Z"
}
```

> Messages are validated and inserted using SQL via the `pg` client.

---

## 💡 Tips

- Simulate MQTT input using `mosquitto_pub` or [MQTT Explorer](https://mqtt-explorer.com/)
- Use TimescaleDB features like continuous aggregates and compression
- Consider indexing columns like `timestamp`, `machineId`, and `sensorType`

---

## 📚 Why TimescaleDB?

- Seamless integration with PostgreSQL
- Optimized for time-series inserts and queries
- Advanced features like compression, downsampling, and native SQL support
- Excellent for industrial/IoT sensor data
